clearvars
close all

seed = 0;
logt = 4;
L = 50;
lognc = 5;
sLL = 20;
dt = 10;
formatSpec = '%f';
implist={'Thread','LessComms'};
rslist={'r','s'};

newmap = jet;
newmap(1,:) = [0.5, 0.5, 0.5];

for k=1:2
FILENAME = sprintf('%d%sP1,%d,%d,%d,%d,%d.txt',seed,implist{k},logt,L,lognc,sLL,dt);

fileID = fopen(FILENAME,'r');

A = fscanf(fileID,formatSpec);

for i=1:64
    for j=1:64
        value=A((i-1)*64 + j);
        if value>=0
            B(i,j)=value;
        else
            B(i,j)=0;
        end
    end
    C(i) = B(i,i);
    B(i,i)=0;
end
if rslist{k}=='s'
    B=B';
end

for i=1:64
    tr(i)=C(i); %Total recieved
    tmpis(i)=0; %Total sent
    for j=1:64
        tr(i)=tr(i)+B(i,j);
        tmpis(i)=tmpis(i)+B(j,i);
    end
end

figure(k*2-1);
hold on, surf(B);
colormap(newmap);
xlim([1,64]);
ylim([1,64]);
xlabel('Receive Processor');
ylabel('Send Processor');
caxis([0,50]);
colorbar()
set(gca, 'FontSize', 20);
set(gca,'box','off');
plotname = sprintf('%d%sP1,%d,%d,%d,%d,%d.png',seed,implist{k},logt,L,lognc,sLL,dt);
saveas(gcf,plotname)

figure(k*2);
bar([tmpis',C'],1,'stacked');
xlim([1,64]);
ylim([0,1800]);
xlabel('Processor');
ylabel('Systems Sent');
set(gca, 'FontSize', 20);
set(gcf,'units','points','position',[10,10,400,300]);
set(gca,'box','off');
set(gca,'linewidth',2);
plotname = sprintf('%d%sSend1,%d,%d,%d,%d,%d.png',seed,implist{k},logt,L,lognc,sLL,dt);
saveas(gcf,plotname)
end